package cz.drg.clasificator.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;


public class ResultSetToHeaderListConvertor implements HeaderListReader{

    private final ResultSet resultSet;
    Map<String, Integer> headers;
    List<List<String>> columns;
            
    public ResultSetToHeaderListConvertor(ResultSet resultSet) {
        this.resultSet = resultSet;
        readResultSet();
    }
    
    private void readResultSet(){
        readHeadersFromResultSet();
        initColumns(headers.size());
        readRowsFromResultSet();
    }
    
    private void readHeadersFromResultSet(){
        
        try {
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int columnCount = rsmd.getColumnCount();

            headers = new HashMap<>();
            
            for (int i = 1; i <= columnCount; i++ ) {
                String name = rsmd.getColumnName(i);
                headers.put(name, i-1);
            }
            
        } catch (SQLException ex) {
            Logger.getLogger(ResultSetToHeaderListConvertor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    private void readRowsFromResultSet(){
        
        try {
            
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int columnCount = rsmd.getColumnCount();
            
            while(resultSet.next()){
                
                for (int i = 1; i <= columnCount; i++) {
                    
                    String colVal = resultSet.getString(i);
                    
                    columns.get(i-1).add(colVal);
                }
                
            }
        } catch (SQLException ex) {
            Logger.getLogger(ResultSetToHeaderListConvertor.class.getName()).log(Level.SEVERE, null, ex);
        }
        
    }
    
    private void initColumns(int columnsAmmount){
        columns = new ArrayList<>();
        
        for (int i = 0; i < columnsAmmount; i++) {
            columns.add(new ArrayList<>());
        }
    }
    
    @Override
    public Map<String, Integer> getHeadersWithIndexes() {
        return headers;
    }

    @Override
    public List<List<String>> getColumnLists() {
        return columns;
    }

    @Override
    public int getNumberOfLines() {
        return columns.get(0).size();
    }

}
